/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.pa.problem;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.pa.system.PASystem;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.fru.CommonPaFru;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import com.ibm.hwmca.xfw.pa.problem.ProblemDataBase;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ProblemSummary {
    public String uuid = "";
    public String fruHash = "";
    public String problemNumber = "";
    public String primaryReportingMTMS = "";
    public String reportingName = "";
    public String secondaryReportingMTMS = "";
    public String failingMTMS = "";
    public String refcode = "";
    public String problemState = "";
    public String lastmodifiedtime = "";
    public String firstReportedTime = "";
    public String sequenceNumber = "";
    public static String version = "";
    public String pmh = "";
    public String serviceableEventText = "";
    public String bundle = "";
    public String key = "";
    public String[] location = null;
    public String[] partnumbers = null;
    private static final String TRACE_MASKT = "XPASUMMT";
    private static final String TRACE_MASKF = "XPASUMMF";
    private static final String TRACE_MASKD = "XPASUMMD";
    private CommonProblem problem = null;

    public ProblemSummary(CommonProblem theProblem) {
        this.problem = theProblem;
        this.primaryReportingMTMS = this.problem.getFailingSystem().toString();
        this.failingMTMS = this.problem.getFailingSystem().toString();
        this.secondaryReportingMTMS = this.problem.getSecondaryReportingSystem().toString();
        this.firstReportedTime = Long.toString(this.problem.getFirstReportedTimestamp());
        this.lastmodifiedtime = Long.toString(this.problem.getLastReportedTimestamp());
        PASystem primarySystem = this.problem.getReportingRemoteMachineSystem();
        this.reportingName = primarySystem.getMOSystemName();
        this.refcode = this.problem.getRefcode();
        this.pmh = this.problem.getPMH();
        version = "1";
        this.serviceableEventText = this.problem.getServiceableEventText().toString();
        LocalizableText fixwarefix = (LocalizableText)this.problem.getProblemData().get("pdc_FIRMWARE_FIX");
        this.bundle = fixwarefix.getBundleName();
        this.key = fixwarefix.getKey();
        int partCount = this.problem.getPartCount();
        this.partnumbers = new String[partCount];
        ArrayList<ArrayList> locationCodeList = new ArrayList<ArrayList>();
        List fruList = this.problem.getParts();
        int fruCounter = 0;
        if (fruList != null) {
            Iterator fruIt = fruList.iterator();
            while (fruIt.hasNext()) {
                CommonPaFru theFru = (CommonPaFru)fruIt.next();
                String partNumber = theFru.getPartNumber();
                if (partNumber == null || partNumber != "") {
                    partNumber = "partnumber";
                }
                this.partnumbers[fruCounter] = partNumber;
                ++fruCounter;
                locationCodeList.add(theFru.getLocationList());
            }
        }
        this.location = locationCodeList.toArray(new String[1]);
        this.fruHash = Integer.toString(ProblemDataBase.hashFrulist(this.problem.getRefcode(), this.problem.getParts()));
        this.uuid = this.problem.getUniqueKey();
        this.sequenceNumber = Integer.toString(this.problem.getSequenceNumber());
        this.problemState = Integer.toString(this.problem.getProblemState());
        this.problemNumber = Integer.toString(this.problem.getProblemNumber());
    }

    public static String buildFileContents(CommonProblem problem) {
        try {
            StringBuffer dataBuffer = new StringBuffer(50);
            dataBuffer.append(version);
            dataBuffer.append(";");
            dataBuffer.append(Long.toString(problem.getFirstReportedTimestamp()));
            dataBuffer.append(";");
            dataBuffer.append(Long.toString(problem.getLastReportedTimestamp()));
            dataBuffer.append(";");
            PASystem primarySystem = problem.getReportingRemoteMachineSystem();
            dataBuffer.append(primarySystem);
            dataBuffer.append(";");
            dataBuffer.append(primarySystem.getMOSystemName());
            dataBuffer.append(";");
            PASystem secondarySystem = problem.getSecondaryReportingSystem();
            if (secondarySystem != null) {
                dataBuffer.append(secondarySystem);
            } else {
                dataBuffer.append("none");
            }
            dataBuffer.append(";");
            String refcode = problem.getRefcode();
            if (refcode == null) {
                refcode = "00000000";
            }
            dataBuffer.append(refcode);
            dataBuffer.append(";");
            String pmh = problem.getPMH();
            if (pmh == null) {
                pmh = "nopmh";
            }
            dataBuffer.append(pmh);
            dataBuffer.append(";");
            String serviceableEventText = problem.getServiceableEventText().toString();
            if (serviceableEventText != null) {
                dataBuffer.append(serviceableEventText);
            } else {
                dataBuffer.append("none");
            }
            dataBuffer.append(";");
            LocalizableText fixwarefix = (LocalizableText)problem.getProblemData().get("pdc_FIRMWARE_FIX");
            if (fixwarefix != null) {
                dataBuffer.append(fixwarefix.getBundleName());
                dataBuffer.append(";");
                dataBuffer.append(fixwarefix.getKey());
            } else {
                dataBuffer.append("none");
                dataBuffer.append(";");
                dataBuffer.append("none");
            }
            dataBuffer.append(";");
            dataBuffer.append(Integer.toString(problem.getPartCount()));
            dataBuffer.append(";");
            List fruList = problem.getParts();
            if (fruList != null) {
                Iterator fruIt = fruList.iterator();
                while (fruIt.hasNext()) {
                    CommonPaFru theFru = (CommonPaFru)fruIt.next();
                    String partNumber = theFru.getPartNumber();
                    if (partNumber == null || partNumber != "") {
                        partNumber = "partnumber";
                    }
                    dataBuffer.append(partNumber);
                    dataBuffer.append(";");
                    ArrayList locationCodeList = theFru.getLocationList();
                    int locListSize = locationCodeList.size();
                    dataBuffer.append(locListSize);
                    dataBuffer.append(";");
                    Iterator locIt = locationCodeList.iterator();
                    while (locIt.hasNext()) {
                        String location = (String)locIt.next();
                        if (location == null || location != "") {
                            location = "location";
                        }
                        dataBuffer.append(location);
                        dataBuffer.append(";");
                    }
                }
            }
            return dataBuffer.toString();
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "got an exception");
            Trace.trace(TRACE_MASKF, e);
            return null;
        }
    }

    public ProblemSummary(File file) throws Exception {
        Trace.trace(TRACE_MASKD, "--> ProblemSummary(" + file.getName() + ")");
        String fileName = file.getName();
        this.uuid = ProblemDataBase.getSubStringElement(fileName, 1, ".");
        this.sequenceNumber = ProblemDataBase.getSubStringElement(fileName, 2, ".");
        this.fruHash = ProblemDataBase.getSubStringElement(fileName, 3, ".");
        this.problemState = ProblemDataBase.getSubStringElement(fileName, 4, ".");
        this.problemNumber = ProblemDataBase.getSubStringElement(fileName, 5, ".");
        String fileData = "";
        FileInputStream fis = new FileInputStream(file);
        long filesize = file.length();
        byte[] data = new byte[(int)filesize];
        fis.read(data);
        String fileContents = new String(data);
        Trace.trace(TRACE_MASKD, "the file contents are" + fileContents);
        version = ProblemDataBase.getSubStringElement(fileContents, 1, ";");
        if (version.equals("1")) {
            Trace.trace(TRACE_MASKD, "got a version 1 format file");
            this.firstReportedTime = ProblemDataBase.getSubStringElement(fileContents, 2, ";");
            this.lastmodifiedtime = ProblemDataBase.getSubStringElement(fileContents, 3, ";");
            this.primaryReportingMTMS = ProblemDataBase.getSubStringElement(fileContents, 4, ";");
            this.reportingName = ProblemDataBase.getSubStringElement(fileContents, 5, ";");
            this.secondaryReportingMTMS = ProblemDataBase.getSubStringElement(fileContents, 6, ";");
            this.refcode = ProblemDataBase.getSubStringElement(fileContents, 7, ";");
            this.pmh = ProblemDataBase.getSubStringElement(fileContents, 8, ";");
            this.serviceableEventText = ProblemDataBase.getSubStringElement(fileContents, 9, ";");
            this.bundle = ProblemDataBase.getSubStringElement(fileContents, 10, ";");
            this.key = ProblemDataBase.getSubStringElement(fileContents, 11, ";");
            String numFrus = ProblemDataBase.getSubStringElement(fileContents, 12, ";");
            Trace.trace(TRACE_MASKD, "numFrus is " + numFrus);
            int fruCount = 0;
            try {
                fruCount = Integer.valueOf(numFrus);
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "took an exception formating the frucount. skip it");
            }
            Trace.trace(TRACE_MASKD, "there are " + fruCount + " frus");
            ArrayList<String> locationCodes = new ArrayList<String>();
            this.partnumbers = new String[fruCount];
            int offset = 0;
            for (int i = 0; i < fruCount; ++i) {
                this.partnumbers[i] = ProblemDataBase.getSubStringElement(fileContents, 13 + offset, ";");
                String numLocCodes = ProblemDataBase.getSubStringElement(fileContents, 14 + offset, ";");
                int locationCodeCount = Integer.valueOf(numLocCodes);
                for (int k = 0; k < locationCodeCount; ++k) {
                    locationCodes.add(ProblemDataBase.getSubStringElement(fileContents, 15 + offset + k, ";"));
                }
                offset += 2 + locationCodeCount;
            }
            if (locationCodes.size() != 0) {
                this.location = locationCodes.toArray(new String[1]);
            }
        } else {
            throw new HException("Invalid file format");
        }
        Trace.trace(TRACE_MASKD, "<-- ProblemSummary()");
    }

    public ProblemSummary() {
    }

    public String toString() {
        return " uuid = " + this.uuid + " fruHash = " + this.fruHash + " problemNumber = " + this.problemNumber + " primaryReportingMTMS = " + this.primaryReportingMTMS + " reportingName = " + this.reportingName + " secondaryReportingMTMS = " + this.secondaryReportingMTMS + " failingMTMS = " + this.failingMTMS + " refcode = " + this.refcode + " problemState = " + this.problemState + " lastmodifiedtime = " + this.lastmodifiedtime + " firstReportedTime = " + this.firstReportedTime + " sequenceNumber = " + this.sequenceNumber + " serviceableEventText =" + this.serviceableEventText + " pmh = " + this.pmh + " bundle = " + this.bundle + " key = " + this.key + " version =" + version;
    }
}

